# -*- coding:utf-8 -*-

import ConfigParser
#import codecs
import os.path
from qsphere_tools import *

from PyQt4 import QtCore, QtGui
from PyQt4 import QtCore, QtGui
from PyQt4.QtCore import * 
from PyQt4.QtGui import * 
from qgis.core import *
from qgis.gui import *

import urllib

   
#==================================================
# FUNCTIONS TO LOAD (IMPORT) AND SAVE / EXPORT QSP
#==================================================
def SaveQSP(self, zFile):
    zIndex = self.tabWidget.currentIndex()
    zLOG = open(zFile, "w")
    Config = ConfigParser.ConfigParser()
    
    zTabs = self.tabWidget.count()
    zObj = None
    for i in range(zTabs):
        self.tabWidget.setCurrentIndex(i)
        zTab = self.tabWidget.currentWidget()
        zObjs = zTab.children()
        for j in range(len(zObjs)):
            zNameObj = "%s" % (zObjs[j].accessibleName())
            if zNameObj != "" and (not zObjs[j].metaObject().className()=="QLabel") and zNameObj.find("help_")==-1 and zNameObj.find("Ajouter_")==-1 and zNameObj.find("Effacer_")==-1 :
               Config.add_section(zNameObj)
               zClassObjName = "%s" % (zObjs[j].metaObject().className())
               Config.set(zNameObj,'Type',zClassObjName)
               if zClassObjName=="QCalendarWidget" : Config.set(zNameObj,'Date',ReturnDate(self, zObjs[j]))
               elif zClassObjName=="QTextEdit" : Config.set(zNameObj,'Text',zObjs[j].toPlainText())
               elif zClassObjName in ("QLineEdit", "MySimpleWidgetLineEdit", "MyWidgetLineEdit") : Config.set(zNameObj,'Text',zObjs[j].text())
               elif zClassObjName=="QComboBox" :
                   Config.set(zNameObj,'ItemCount',zObjs[j].model().rowCount())
                   for k in range(zObjs[j].model().rowCount()): Config.set(zNameObj,'Item_%s' % (k),zObjs[j].itemText(k))
                   Config.set(zNameObj,'Index',zObjs[j].currentIndex())
               elif zClassObjName=="QGroupBox" :
                    zChildren = zObjs[j].children()
                    for i in range(len(zChildren)):
                        zChild = zChildren[i]
                        zChildClassName = "%s" % (zChild.metaObject().className())
                        if zChildClassName == "QRadioButton" and zChild.isChecked(): Config.set(zNameObj, "radio","%s" % (i))
                        elif zChildClassName == "QComboBox" : Config.set(zNameObj,'Index',zChild.currentIndex())
                        elif zChildClassName == "QTableWidget":
                             Config.set(zNameObj,'subtype',zChildClassName)
                             Config.set(zNameObj,'zRows',zChild.rowCount())
                             Config.set(zNameObj,'zCols',zChild.columnCount())
                             for k in range(zChild.rowCount()):
                                  zWidget = zChild.cellWidget(k, 0)
                                  Config.set(zNameObj,'zRow_%s' % (k),zWidget.value())
                        elif zChildClassName == "QTableView":
                             Config.set(zNameObj,'subtype',zChildClassName)
                             zItems = ""
                             Config.set(zNameObj,'ItemCount',zChild.model().rowCount())
                             for k in range(zChild.model().rowCount()):
                                 zValues = ""
                                 for l in range(zChild.model().columnCount()): zValues+= "%s" % (zChild.model().item(k, l).text()) if zValues == "" else "|%s" % (zChild.model().item(k, l).text())
                                 Config.set(zNameObj,'Item_%s' % (k),zValues)
                                 zItem = zChild.model().item(k, 0)
                                 if zItem.checkState()== Qt.Checked: zItems+= "%s" % (k) if zItems=="" else "|%s" % (k)  
                             Config.set(zNameObj,'Indexes',zItems)                                      
                   
               elif zClassObjName=="QTableView" :
                   zItems = ""
                   Config.set(zNameObj,'ItemCount',zObjs[j].model().rowCount())
                   for k in range(zObjs[j].model().rowCount()):
                       zValues = ""
                       for l in range(zObjs[j].model().columnCount()): zValues+= zObjs[j].model().item(k, l).text() if zValues == "" else "|"+zObjs[j].model().item(k, l).text()
                       Config.set(zNameObj,'Item_%s' % (k),zValues)
                       zItem = zObjs[j].model().item(k, 0)
                       if zItem.checkState()== Qt.Checked: zItems+= "%s" % (k) if zItems=="" else "|%s" % (k)  
                   Config.set(zNameObj,'Indexes',zItems)

               elif zClassObjName=="QTableWidget" :
                  Config.set(zNameObj,'zRows',zObjs[j].rowCount())
                  Config.set(zNameObj,'zCols',zObjs[j].columnCount())
                  for z in range(zObjs[j].columnCount()):
                      zObj = zObjs[j].cellWidget(0, z)
                      if zObj != None :
                          zClassWidgetName = zObjs[j].cellWidget(0, z).metaObject().className()
                          Config.set(zNameObj,'zWidget_%s' % (z), zClassWidgetName+"|"+zObjs[j].cellWidget(0, z).accessibleDescription())
                      else: Config.set(zNameObj,'zWidget_%s' % (z), "standard")   

                  for k in range(zObjs[j].rowCount()):
                      zLine = ""
                      for z in range(zObjs[j].columnCount()):
                          zObj = zObjs[j].cellWidget(0, z)
                          if zObj != None :
                              zWidget = zObjs[j].cellWidget(k, z)
                              if zObjs[j].cellWidget(0, z).metaObject().className()=="QComboBox" :
                                  if zWidget.isEditable() : zLine+= "%s" % (returnText(zWidget.currentText())) if zLine == "" else "|%s" % (returnText(zWidget.currentText()))  
                                  else : zLine+= "%s" % (zWidget.currentIndex()) if zLine == "" else "|%s" % (zWidget.currentIndex())
                              elif zObjs[j].cellWidget(0, z).metaObject().className()=="QCheckBox" : zLine+= "%s" % (zWidget.checkState()) if zLine == "" else "|%s" % (zWidget.checkState())
                              elif zObjs[j].cellWidget(0, z).metaObject().className()=="MySpinBox" : zLine+= "%s" % (zWidget.value()) if zLine == "" else "|%s" % (zWidget.value())
                              elif zObjs[j].cellWidget(0, z).metaObject().className() in ("QPushButton", "MyButton") : zLine+= "action" if zLine == "" else "|action"
                              else : zLine+= "%s" % (returnText(zWidget.text())) if z==0 else "|%s" % (returnText(zWidget.text()))
                          else:
                              zCell = zObjs[j].item(k, z)
                              if zCell != None : zLine+= "%s" % (zObjs[j].item(k, z).text()) if zLine == "" else  "|%s" % (zObjs[j].item(k, z).text())
                              else : zLine+= "" if (zLine == "" and z == 0) else  "|"  
                      Config.set(zNameObj,'zRow_%s' % (k),zLine)

    #Config.write(codecs.open(zFile,'wb+','utf-8'))
    Config.write(zLOG)
    CloseLOG(zLOG)
    self.setWindowTitle("%s%s" % (self.racWindowTitle,zFile))
    self.listeOnglets.setCurrentIndex(zIndex)


def returnText(zText):
    if zText == "" : zText = " "
    return zText

def LoadQSP(self, zFile):
    zFile = os.path.abspath(zFile)
    self.setWindowTitle("%s%s" % (self.racWindowTitle,zFile))
    zIndex = self.tabWidget.currentIndex()
    zTitle = "Information"
    
    config = ConfigParser.ConfigParser()
    config.read(zFile)
    zSections = config.sections()

    self.tabWidget.setVisible(False)
    self.progressBar.setVisible(True)
    zBounds = len(zSections)
    
    zMsg1 = QtGui.QApplication.translate("QSphere","Object ", None, QtGui.QApplication.UnicodeUTF8)
    
    for i in range(zBounds):
        zSection = zSections[i]
        zObj = getWidget(self, zSection)

        if zObj !=None :
            zClassObjName = "%s" % (zObj.metaObject().className())
            zType = config.get(zSection,'Type')

            if zType == zClassObjName :
           
                if zClassObjName=="QCalendarWidget" : 
                    zInfos = config.get(zSection,'Date')
                    zInfos = zInfos.rstrip()
                    if zInfos!="" and zInfos.find("-")!=-1:
                       zEltsDate = zInfos.split("-")
                       zObj.setSelectedDate(QDate(int(zEltsDate[0]), int(zEltsDate[1]), int(zEltsDate[2]) ))
                    else: zObj.showToday()

                elif zClassObjName=="QTextEdit" :
                    zInfos = config.get(zSection,'Text')
                    zInfos = zInfos.rstrip()
                    if zSection != "coherence" : zObj.setPlainText(zInfos)
                    else : self.UpdateCoherence(zSection, zInfos)

                elif zClassObjName in ("QLineEdit", "MySimpleWidgetLineEdit", "MyWidgetLineEdit") :
                    zInfos = config.get(zSection,'Text')
                    zInfos = zInfos.rstrip()
                    zObj.setText(zInfos)

                elif zClassObjName=="QComboBox" :
                    zInfos = config.get(zSection,'Index')
                    zIndexObj = int(zInfos.rstrip())
                    zInfosItem = config.get(zSection,'ItemCount')
                    zItemCount = int(zInfosItem.rstrip())
                    zObj.clear()
                    for k in range(zItemCount): zObj.addItem(config.get(zSection,'Item_%s' % (k)))
                    zObj.setCurrentIndex(zIndexObj)

                elif zClassObjName=="QTableView" : ReLOADTableView(self, config, zObj, zSection)
                     
                elif zClassObjName=="QGroupBox" :
                    zChildren = zObj.children()
                    zInfos = "%s" % (config.get(zSection, "radio"))
                    zIndexObj = int(zInfos.rstrip())
                    try : zChildren[zIndexObj].setChecked(True)
                    except : pass

                    for child in zChildren :
                        if child.metaObject().className()== "QTableView" : ReLOADTableView(self, config, child, zSection)
                        elif child.metaObject().className()== "QTableWidget" :
                            child.clearContents()
                            for j in range(child.rowCount()): child.removeRow(0)
                            zRows = int(config.get(zSection,'zRows'))
                            for j in range(zRows):
                                 child.insertRow(j)
                                 zInfos = float(config.get(zSection,'zRow_%s' % (j)))
                                 AddLineWidget(self, child, j,  0, 4, 0, zInfos)
                        elif child.metaObject().className()== "QComboBox" :
                            zIndexCombo = int(config.get(zSection, "Index"))
                            child.setCurrentIndex(zIndexCombo)

                elif zClassObjName=="QTableWidget" :
                            ReLOADTableWidget(self, config, zObj, zSection)
                            if zObj.accessibleName() == "tablemotsclefsf":
                               for i in range(zObj.rowCount()):
                                   zCheckBox = zObj.cellWidget(i, 1)
                                   for j in range(2,5):
                                       zItemEditLine = zObj.cellWidget(i, j)
                                       try : zItemEditLine.setEnabled(zCheckBox.isChecked())
                                       except : pass

            else :
                zMsg2 = QtGui.QApplication.translate("QSphere","'s properties not similar. Import data aborded.", None, QtGui.QApplication.UnicodeUTF8)
                SendMessage(self, zTitle , "%s%s%s" % (zMsg1, zSection, zMsg2), QgsMessageBar.WARNING, 5)
        else :
            zMsg2 = QtGui.QApplication.translate("QSphere"," not find in the QSphere's collection.", None, QtGui.QApplication.UnicodeUTF8)
            SendMessage(self, zTitle , "%s%s%s" % (zMsg1, zSection, zMsg2), QgsMessageBar.WARNING, 5)

        self.progressBar.setValue(int(100 * i/zBounds))

    self.listeOnglets.setCurrentIndex(zIndex)
    self.progressBar.setValue(0)
    self.tabWidget.setVisible(True)
    self.progressBar.setVisible(False)
    
#==============================
# FONCTION TO WRITE XML EXPORT       
#==============================
def ExportToXML(self, zFile):
    zIndex = self.tabWidget.currentIndex()
    zLOG = file(zFile, "w")
    
    if not zLOG : return
    
    MakeEnteteXML(self, zLOG)
    MakeFileIdentifierXML(self, zLOG, zFile)
    MakeFileLanguageXML(self, zLOG)
    MakeCharacterSetCodeXML(self, zLOG)
    MakeHierarchyLevelXML(self, zLOG)
    MakeContactXML(self, zLOG)
    MakeDateStampXML(self, zLOG)
    MakeMetadataStandardNameXML(self, zLOG)
    MakeMetadataStandardVersionXML(self, zLOG)
    MakeSpatialRepresentation(self, zLOG)    
    MakeReferenceSystemInfoXML(self, zLOG)
    MakeIdentificationInfoXML(self, zLOG)
    MakeDistributionInfoXML(self, zLOG)
    MakeDataQualityInfoXML(self, zLOG)
    MakeEndXML(self, zLOG)

    CloseLOG(zLOG)
    self.listeOnglets.setCurrentIndex(zIndex)

def ExportCatToXML(self, zFile):
    zIndex = self.tabWidget.currentIndex()
    zLOG = file(zFile, "w")
    
    if not zLOG : return
    
    MakeEnteteCatXML(self, zLOG)
    MakeNameCat(self, zLOG)
    MakeScopeCat(self, zLOG)
    MakeVersionCat(self, zLOG)
    MakeDateCat(self, zLOG)
    MakeProductorCat(self, zLOG)
    MakeFieldMapXML(self, zLOG)
    MakeEndCatXML(self, zLOG)

    CloseLOG(zLOG)
    self.listeOnglets.setCurrentIndex(zIndex)
    
#------------------------------------
# FONCTION TO WRITE BLOCX XML EXPORT       
#------------------------------------
def MakeEnteteCatXML(self, zLOG):
    zPath = os.path.dirname(__file__).replace("\\","/")
    zFileXSL = "%s/xml/XSL/transformation_%s.xsl" % (zPath, self.Lang)
    #zXSL = '<?xml-stylesheet type="text/xsl" href="XSL/transformation_%s.xsl"?>' % (self.Lang) if os.path.exists(zFileXSL) else ""
    zXSL = ""
    zObj = getWidget(self, "namelayer")
    
    WriteInLOG(zLOG, '<?xml version="1.0" encoding="UTF-8"?>' \
                     '%s' \
                     '<gfc:FC_FeatureCatalogue uuid="CA_%s" xmlns:gfc="http://www.isotc211.org/2005/gfc" xmlns:gmd="http://www.isotc211.org/2005/gmd"' \
                     ' xmlns:gco="http://www.isotc211.org/2005/gco"' \
                     ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"' \
                     ' xsi:schemaLocation="http://www.isotc211.org/2005/gfc http://www.isotc211.org/2005/gfc/gfc.xsd">\n' %(zXSL, zObj.text()))

def MakeEndCatXML(self, zLOG):
     WriteInLOG(zLOG, '</gfc:FC_FeatureCatalogue>')   

def MakeNameCat(self, zLOG):
     zValue, zText = GetTextWidget(self, "namelayer", False)
     WriteInLOG(zLOG, '<gfc:name><gco:CharacterString>\n')
     WriteInLOG(zLOG, '%s - %s' % (zValue,"Catalogue d'attributs"))
     WriteInLOG(zLOG, '</gco:CharacterString></gfc:name>\n')

def MakeScopeCat(self, zLOG):
    zObj = getWidget(self, "namelayer")
    WriteInLOG(zLOG, '<gfc:scope>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.text()))
    WriteInLOG(zLOG, '</gfc:scope>\n')

def MakeVersionCat(self, zLOG):
    WriteInLOG(zLOG, '<gfc:versionNumber>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>NC</gco:CharacterString>\n')
    WriteInLOG(zLOG, '</gfc:versionNumber>\n')

def MakeDateCat(self, zLOG):
    zObj = getWidget(self, "datecredata")
    WriteInLOG(zLOG, '<gfc:versionDate>\n')
    WriteInLOG(zLOG, '<gco:Date>%s</gco:Date>\n' % (ReturnDate(self, zObj)))
    WriteInLOG(zLOG, '</gfc:versionDate> \n')   

def MakeProductorCat(self, zLOG):
    zObj = getWidget(self, "tableroles")
    for i in range(zObj.rowCount()):
        zValue = self.DicoListOfRules[zObj.cellWidget(i, 0).currentIndex()]
        if zValue == "pointOfContact" : 
            WriteInLOG(zLOG, '<gfc:producer>\n')
            MakeResponsibleParty(self, zLOG, zObj, zValue, i, True)
            WriteInLOG(zLOG, '</gfc:producer>\n')
            break
    
def MakeFieldMapXML(self, zLOG):
    WriteInLOG(zLOG, '<gfc:featureType>\n')
    WriteInLOG(zLOG, '<gfc:FC_FeatureType>\n')
    WriteInLOG(zLOG, '<gfc:typeName><gco:LocalName>%s</gco:LocalName></gfc:typeName>\n' % (self.ComboLayers.currentText()))
    WriteInLOG(zLOG, '<gfc:definition><gco:CharacterString>%s</gco:CharacterString></gfc:definition>\n' % (""))

    zObj = getWidget(self, "tabledico")
    for i in range(zObj.rowCount()):
        WriteInLOG(zLOG, '<gfc:carrierOfCharacteristics>\n')
        WriteInLOG(zLOG, '<gfc:FC_FeatureAttribute>\n')
        WriteInLOG(zLOG, '<gfc:memberName>\n')
        WriteInLOG(zLOG, '<gco:LocalName>%s</gco:LocalName>\n' % (zObj.item( i, 1 ).text()))
        WriteInLOG(zLOG, '</gfc:memberName>\n')
        WriteInLOG(zLOG, '<gfc:definition><gco:CharacterString>%s</gco:CharacterString></gfc:definition>\n' % (zObj.item( i, 5 ).text()))
        WriteInLOG(zLOG, '<gfc:cardinality>\n')
        WriteInLOG(zLOG, '<gco:Multiplicity>\n')
        WriteInLOG(zLOG, '<gco:range>\n')
        WriteInLOG(zLOG, '<gco:MultiplicityRange>\n')
        WriteInLOG(zLOG, '<gco:lower>\n')
        WriteInLOG(zLOG, '<gco:Integer>1</gco:Integer>\n')
        WriteInLOG(zLOG, '</gco:lower>\n')
        WriteInLOG(zLOG, '<gco:upper>\n')
        WriteInLOG(zLOG, '<gco:UnlimitedInteger isInfinite="false">1</gco:UnlimitedInteger>\n')
        WriteInLOG(zLOG, '</gco:upper>\n')
        WriteInLOG(zLOG, '</gco:MultiplicityRange>\n')
        WriteInLOG(zLOG, '</gco:range>\n')
        WriteInLOG(zLOG, ' </gco:Multiplicity>\n')
        WriteInLOG(zLOG, '</gfc:cardinality>\n')
        WriteInLOG(zLOG, '<gfc:valueType>\n')
        WriteInLOG(zLOG, '<gco:TypeName>\n')
        WriteInLOG(zLOG, '<gco:aName>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.item( i, 2 ).text()))
        WriteInLOG(zLOG, '</gco:aName>\n')
        WriteInLOG(zLOG, '</gco:TypeName>\n')
        WriteInLOG(zLOG, '</gfc:valueType>\n')
        WriteInLOG(zLOG, '</gfc:FC_FeatureAttribute>\n')
        WriteInLOG(zLOG, '</gfc:carrierOfCharacteristics>\n')

    WriteInLOG(zLOG, '</gfc:FC_FeatureType>\n')
    WriteInLOG(zLOG, '</gfc:featureType>\n')
    
def MakeEnteteXML(self, zLOG):
    zPath = os.path.dirname(__file__).replace("\\","/")
    zFileXSL = "%s/xml/XSL/transformation_%s.xsl" % (zPath, self.Lang)
    #zXSL = '<?xml-stylesheet type="text/xsl" href="XSL/transformation_%s.xsl"?>' % (self.Lang) if os.path.exists(zFileXSL) else ""
    zXSL = ""
    
    WriteInLOG(zLOG, '<?xml version="1.0" encoding="UTF-8"?>' \
                     '%s' \
                     '<gmd:MD_Metadata xsi:schemaLocation="http://www.isotc211.org/2005/gmd http://schemas.opengis.net/iso/19139/20060504/gmd/gmd.xsd"' \
                     ' xmlns:gmd="http://www.isotc211.org/2005/gmd"' \
                     ' xmlns:gco="http://www.isotc211.org/2005/gco"' \
                     ' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"' \
                     ' xmlns:gml="http://www.opengis.net/gml"' \
                     ' xmlns:xlink="http://www.w3.org/1999/xlink">\n' % (zXSL))

def MakeFileIdentifierXML(self, zLOG, zFile):
    zValue = os.path.basename(zFile)
    WriteInLOG(zLOG, '<gmd:fileIdentifier>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValue)) 
    WriteInLOG(zLOG, '</gmd:fileIdentifier>\n')

def MakeFileLanguageXML(self, zLOG):
    zObj = getWidget(self, "langmetada")
    zValue = zObj.currentText()#.toPlainText()
    MakeBlocLangue(self, zLOG, zValue)

def MakeCharacterSetCodeXML(self, zLOG):
    zObj = getWidget(self, "tablecarac")
    zValue = "MD_CharacterSetCode_%s" % (zObj.currentText().lower())
    WriteInLOG(zLOG, '<gmd:characterSet>\n')
    WriteInLOG(zLOG, '<gmd:MD_CharacterSetCode codeListValue="%s" codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/codelist/gmxCodelists.xml#MD_CharacterSetCode">%s</gmd:MD_CharacterSetCode>\n' % (zValue, zValue))
    WriteInLOG(zLOG, '</gmd:characterSet>\n')

def MakeHierarchyLevelXML(self, zLOG):
    zObj = getWidget(self, "typedata")
    zValue = self.TypeData[zObj.currentIndex()]
    WriteInLOG(zLOG, '<gmd:hierarchyLevel>\n')
    WriteInLOG(zLOG, '<gmd:MD_ScopeCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/gmxCodelists.xml#MD_ScopeCode" codeListValue="%s">%s</gmd:MD_ScopeCode>\n' % (zValue, zValue))
    WriteInLOG(zLOG, '</gmd:hierarchyLevel>\n')

def MakeContactXML(self, zLOG):
    zObj = getWidget(self, "tableroles")
    for i in range(zObj.rowCount()):
        zValue = self.DicoListOfRules[zObj.cellWidget(i, 0).currentIndex()]
        if zValue == "pointOfContact" :
           MakeBlocRole(self, zLOG, zObj, zValue, i, True)
           break
            
def MakeDateStampXML(self, zLOG):
    zValue, zText = GetTextWidget(self, "datemetada", False)
    WriteInLOG(zLOG, '<gmd:dateStamp>\n')
    WriteInLOG(zLOG, '<gco:Date>%s</gco:Date>\n' % (zValue))
    WriteInLOG(zLOG, '</gmd:dateStamp>\n')

def MakeMetadataStandardNameXML(self, zLOG):
    WriteInLOG(zLOG, '<gmd:metadataStandardName>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>ISO19115</gco:CharacterString>\n')
    WriteInLOG(zLOG, '</gmd:metadataStandardName>\n')

def MakeMetadataStandardVersionXML(self, zLOG):
    WriteInLOG(zLOG, '<gmd:metadataStandardVersion>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>2003/Cor.1:2006</gco:CharacterString>\n')
    WriteInLOG(zLOG, '</gmd:metadataStandardVersion>\n')

def MakeReferenceSystemInfoXML(self, zLOG):
    zObj = getWidget(self, "tablescr")
    for i in range(zObj.rowCount()): 
        zEPSG = zObj.cellWidget(i, 0).text()
        if zObj.rowCount() == 1 :  WriteInLOG(zLOG, '<gmd:referenceSystemInfo>\n')
        else : WriteInLOG(zLOG, '<gmd:referenceSystemInfo id="proj00%s">\n' % (i+1))
        WriteInLOG(zLOG, '<gmd:MD_ReferenceSystem>\n')
        WriteInLOG(zLOG, '<gmd:referenceSystemIdentifier>\n')        
        WriteInLOG(zLOG, '<gmd:RS_Identifier>\n')
        zCodeESPG = int(zEPSG.replace("EPSG:",""))
        WriteInLOG(zLOG, '<gmd:code>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zCodeESPG))
        WriteInLOG(zLOG, '</gmd:code>\n')
        WriteInLOG(zLOG, '<gmd:codeSpace>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>urn:ogc:def:crs:EPSG:6.11</gco:CharacterString>\n')
        WriteInLOG(zLOG, '</gmd:codeSpace>\n')
        WriteInLOG(zLOG, '<gmd:version>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>6.11</gco:CharacterString>\n')
        WriteInLOG(zLOG, '</gmd:version>\n')
        WriteInLOG(zLOG, '</gmd:RS_Identifier>\n')
        WriteInLOG(zLOG, '</gmd:referenceSystemIdentifier>\n')
        WriteInLOG(zLOG, '</gmd:MD_ReferenceSystem>\n')    
        WriteInLOG(zLOG, '</gmd:referenceSystemInfo>\n')

def MakeIdentificationInfoXML(self, zLOG):     
    WriteInLOG(zLOG, '<gmd:identificationInfo>\n')
    WriteInLOG(zLOG, '<gmd:MD_DataIdentification>\n')
    #CITATION BLOC
    WriteInLOG(zLOG, '<gmd:citation>\n')
    WriteInLOG(zLOG, '<gmd:CI_Citation>\n')
    zValue, zText = GetTextWidget(self, "intitule", False)
    WriteInLOG(zLOG, '<gmd:title>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValue))
    WriteInLOG(zLOG, '</gmd:title>\n')
    
    zObj = getWidget(self, "tabledatepubdata")
    for i in range(zObj.rowCount()):
        zValue = zObj.cellWidget(i, 0).text()
        zTypeDate = GetDateType(2, False) 
        if zValue.find("--") == -1 : MakeBlocDate(self, zLOG, zValue, zTypeDate)
    
    for i in range(0, 2):
        zWidgetDate = GetDateType(i, True) 
        zTypeDate = GetDateType(i, False)
        zValue, zText = GetTextWidget(self, zWidgetDate, False)
        if zValue.find("--") == -1 : MakeBlocDate(self, zLOG, zValue, zTypeDate)

    zValue, zText = GetTextWidget(self, "identificator", False)
    WriteInLOG(zLOG, '<gmd:identifier>\n')
    WriteInLOG(zLOG, '<gmd:RS_Identifier>\n')
    WriteInLOG(zLOG, '<gmd:code>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValue))
    WriteInLOG(zLOG, '</gmd:code>\n')
    WriteInLOG(zLOG, '<gmd:codeSpace>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>Unkwon</gco:CharacterString>\n')
    WriteInLOG(zLOG, '</gmd:codeSpace>\n')
    WriteInLOG(zLOG, '</gmd:RS_Identifier>\n')
    WriteInLOG(zLOG, '</gmd:identifier>\n')
               
    WriteInLOG(zLOG, '</gmd:CI_Citation>\n')
    WriteInLOG(zLOG, '</gmd:citation>\n')
    #End CITATION BLOC

    #ABSTRACT BLOC
    zValue, zText = GetTextWidget(self, "resume", False)
    WriteInLOG(zLOG, '<gmd:abstract>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValue))
    WriteInLOG(zLOG, '</gmd:abstract>\n')
    #End ABSTRACT BLOC

    #ROLES BLOC
    zObj = getWidget(self, "tableroles")
    for i in range(zObj.rowCount()):
        zValue = self.DicoListOfRules[zObj.cellWidget(i, 0).currentIndex()]
        if zValue != "pointOfContact" : MakeBlocRole(self, zLOG, zObj, zValue, i, False)
    #End ROLES BLOC

    #BLOC INSPIRE optional keywords 
    zObj = getWidget(self, "tablemotsclefsf")
    for i in range(zObj.rowCount()):
        WriteInLOG(zLOG, '<gmd:descriptiveKeywords>\n')
        WriteInLOG(zLOG, '<gmd:MD_Keywords>\n')
        WriteInLOG(zLOG, '<gmd:keyword>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 0).text()))
        WriteInLOG(zLOG, '</gmd:keyword>\n')

        zValueTHE = zObj.cellWidget(i, 2).text()
        if zValueTHE != "" :
            WriteInLOG(zLOG, '<gmd:thesaurusName>\n')
            WriteInLOG(zLOG, '<gmd:CI_Citation>\n')
            WriteInLOG(zLOG, '<gmd:title>\n')
            WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValueTHE))
            WriteInLOG(zLOG, '</gmd:title>\n')

            zValueDate = zObj.cellWidget(i, 3).text()
            if zValueDate.find("--")==-1:
                zValueTypeDate = GetDateType(zObj.cellWidget(i, 4).currentIndex(), False)
                MakeBlocDate(self, zLOG, zValueDate, zValueTypeDate)
               
            WriteInLOG(zLOG, '</gmd:CI_Citation>\n')
            WriteInLOG(zLOG, '</gmd:thesaurusName>\n')
    
        WriteInLOG(zLOG, '</gmd:MD_Keywords>\n')
        WriteInLOG(zLOG, '</gmd:descriptiveKeywords>\n')
    #End BLOC INSPIRE optional keywords

    #BLOC INSPIRE required keywords
    zObj = getWidget(self, "tablemotsclefso")
    for i in range(zObj.rowCount()):
        WriteInLOG(zLOG, '<gmd:descriptiveKeywords>\n')
        WriteInLOG(zLOG, '<gmd:MD_Keywords>\n')
        WriteInLOG(zLOG, '<gmd:keyword>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 1).currentText()))
        WriteInLOG(zLOG, '</gmd:keyword>\n')
        WriteInLOG(zLOG, '<gmd:thesaurusName>\n')
        WriteInLOG(zLOG, '<gmd:CI_Citation>\n')
        WriteInLOG(zLOG, '<gmd:title>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 0).currentText()))
        WriteInLOG(zLOG, '</gmd:title>\n')

        MakeBlocDate(self, zLOG, self.DateListOfThesaurus[zObj.cellWidget(i, 0).currentIndex()], "publication")

        WriteInLOG(zLOG, '</gmd:CI_Citation>\n')
        WriteInLOG(zLOG, '</gmd:thesaurusName>\n')
        WriteInLOG(zLOG, '</gmd:MD_Keywords>\n')
        WriteInLOG(zLOG, '</gmd:descriptiveKeywords>\n')
    #End BLOC INSPIRE required keywords   

    #BLOC resourceConstraints
    WriteInLOG(zLOG, '<gmd:resourceConstraints>\n')
    WriteInLOG(zLOG, '<gmd:MD_LegalConstraints>\n')
    zObj = getWidget(self, "licence")
    WriteInLOG(zLOG, '<gmd:useLimitation>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.toPlainText()))
    WriteInLOG(zLOG, '</gmd:useLimitation>\n')
    zObj = getWidget(self, "groupedroits")

    if zObj.children()[0].isChecked() :
        WriteInLOG(zLOG, '<gmd:accessConstraints>\n')
        WriteInLOG(zLOG, '<gmd:MD_RestrictionCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#MD_RestrictionCode" codeListValue="otherRestrictions">otherRestrictions</gmd:MD_RestrictionCode>\n')
        WriteInLOG(zLOG, '</gmd:accessConstraints>\n')
        WriteInLOG(zLOG, '<gmd:otherConstraints>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (QtGui.QApplication.translate("QSphere","No restriction for public access with INSPIRE", None, QtGui.QApplication.UnicodeUTF8)))
        WriteInLOG(zLOG, '</gmd:otherConstraints>\n')
    else :
        WriteInLOG(zLOG, '<gmd:accessConstraints>\n')
        WriteInLOG(zLOG, '<gmd:MD_RestrictionCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#MD_RestrictionCode" codeListValue="otherRestrictions">otherRestrictions</gmd:MD_RestrictionCode>\n')
        WriteInLOG(zLOG, '</gmd:accessConstraints>\n')
        zChild = zObj.children()[2]
        zRows = zChild.model().rowCount()
        for i in range(zRows):
            zItem = zChild.model().item(i, 0)
            if zItem.checkState()== Qt.Checked:
                zValue = zChild.model().item(i, 1).text()
                WriteInLOG(zLOG, '<gmd:otherConstraints>\n')
                WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValue))
                WriteInLOG(zLOG, '</gmd:otherConstraints>\n')

    WriteInLOG(zLOG, '</gmd:MD_LegalConstraints>\n')
    WriteInLOG(zLOG, '</gmd:resourceConstraints>\n')
    #End BLOC resourceConstraints

    #BLOC spatialRepresentationType - not yet implemented (vector, raster, other ? ...)
    """
    WriteInLOG(zLOG, '<gmd:spatialRepresentationType>\n')
    WriteInLOG(zLOG, '<gmd:MD_SpatialRepresentationTypeCode codeList="http://librairies.ign.fr/geoportail/resources/CodeLists.xml#MD_SpatialRepresentationTypeCode" codeListValue="vector">vector</gmd:MD_SpatialRepresentationTypeCode>\n')
    WriteInLOG(zLOG, '</gmd:spatialRepresentationType>\n')
    """

    #BLOC Spatial Resolution
    zObj = getWidget(self, "grouperesolutionscale")
    zChild = zObj.children()[2]
    for i in range(zChild.rowCount()):
        zWidget = zChild.cellWidget(i, 0)
        if zObj.children()[0].isChecked() :
            WriteInLOG(zLOG, '<gmd:spatialResolution>\n')
            WriteInLOG(zLOG, '<gmd:MD_Resolution>\n')
            WriteInLOG(zLOG, '<gmd:equivalentScale>\n')
            WriteInLOG(zLOG, '<gmd:MD_RepresentativeFraction>\n')
            WriteInLOG(zLOG, '<gmd:denominator>\n')
            WriteInLOG(zLOG, '<gco:Integer>%s</gco:Integer>\n' % (int(zWidget.value())))
            WriteInLOG(zLOG, '</gmd:denominator>\n')
            WriteInLOG(zLOG, '</gmd:MD_RepresentativeFraction>\n')
            WriteInLOG(zLOG, '</gmd:equivalentScale>\n')
            WriteInLOG(zLOG, '</gmd:MD_Resolution>\n')
            WriteInLOG(zLOG, '</gmd:spatialResolution>\n')
        else:
            zValueMesureUnit = "%s" % (zObj.children()[3].currentText())
            WriteInLOG(zLOG, '<gmd:spatialResolution>\n')
            WriteInLOG(zLOG, '<gmd:MD_Resolution>\n')
            WriteInLOG(zLOG, '<gmd:distance>\n')
            WriteInLOG(zLOG, '<gco:Distance uom="%s">%s</gco:Distance>\n' % (zValueMesureUnit, zWidget.value()))
            WriteInLOG(zLOG, '</gmd:distance>\n')
            WriteInLOG(zLOG, '</gmd:MD_Resolution>\n')
            WriteInLOG(zLOG, '</gmd:spatialResolution>\n')
    #End BLOC Spatial Resolution

    #BLOC Language for the resource
    zObj = getWidget(self, "tablelangues")
    zRows = zObj.model().rowCount()
    for i in range(zRows):
        zItem = zObj.model().item(i, 0)
        if zItem.checkState()== Qt.Checked:
           zValue = zObj.model().item(i, 0).text()
           MakeBlocLangue(self, zLOG, zValue)
    #End BLOC Language for the resource

    #BLOC INSPIRE category(/ISO)
    zObj = getWidget(self, "tablecategories")
    zRows = zObj.model().rowCount() 
    WriteInLOG(zLOG, '<gmd:topicCategory>\n')
    for i in range(zRows):
        zItem = zObj.model().item(i, 0)
        if zItem.checkState()== Qt.Checked: WriteInLOG(zLOG, '<gmd:MD_TopicCategoryCode>%s</gmd:MD_TopicCategoryCode>\n' % (MakeCAT(self, zObj.model().item(i, 2).text())))
    WriteInLOG(zLOG, '</gmd:topicCategory>\n')
    #End BLOC INSPIRE category(/ISO)

    #BLOC Extents
    WriteInLOG(zLOG, '<gmd:extent>\n')
    WriteInLOG(zLOG, '<gmd:EX_Extent>\n')
    zObj = getWidget(self, "tableemprises")
    WriteInLOG(zLOG, '<gmd:description>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>Liste des emprises</gco:CharacterString>\n')
    WriteInLOG(zLOG, '</gmd:description>\n')
    for i in range(zObj.rowCount()):
        WriteInLOG(zLOG, '<gmd:geographicElement>\n')
        WriteInLOG(zLOG, '<gmd:EX_GeographicBoundingBox>\n')
        WriteInLOG(zLOG, '<gmd:westBoundLongitude>\n')
        WriteInLOG(zLOG, '<gco:Decimal>%s</gco:Decimal>\n' % (zObj.cellWidget(i, 2).value()))
        WriteInLOG(zLOG, '</gmd:westBoundLongitude>\n')
        WriteInLOG(zLOG, '<gmd:eastBoundLongitude>\n')
        WriteInLOG(zLOG, '<gco:Decimal>%s</gco:Decimal>\n' % (zObj.cellWidget(i, 3).value()))
        WriteInLOG(zLOG, '</gmd:eastBoundLongitude>\n')
        WriteInLOG(zLOG, '<gmd:southBoundLatitude>\n')
        WriteInLOG(zLOG, '<gco:Decimal>%s</gco:Decimal>\n' % (zObj.cellWidget(i, 1).value()))
        WriteInLOG(zLOG, '</gmd:southBoundLatitude>\n')
        WriteInLOG(zLOG, '<gmd:northBoundLatitude>\n')
        WriteInLOG(zLOG, '<gco:Decimal>%s</gco:Decimal>\n' % (zObj.cellWidget(i, 0).value()))
        WriteInLOG(zLOG, '</gmd:northBoundLatitude>\n')    
        WriteInLOG(zLOG, '</gmd:EX_GeographicBoundingBox>\n')
        WriteInLOG(zLOG, '</gmd:geographicElement>\n')
       
    zObj = getWidget(self, "tableetenduetemporelle")
    for i in range(zObj.rowCount()):
        zWidgetDates = "%s" % (zObj.cellWidget(i, 0).text())
        if zWidgetDates.find("-- --") == -1 :
            zDates = zWidgetDates.split(" ")
            WriteInLOG(zLOG, '<gmd:temporalElement>\n')
            if zObj.rowCount() == 1 :  WriteInLOG(zLOG, '<gmd:EX_TemporalExtent>\n')
            else : WriteInLOG(zLOG, '<gmd:EX_TemporalExtent gml:id="tp00%s">\n' % (i+1)) 
            WriteInLOG(zLOG, '<gmd:extent>\n')
            WriteInLOG(zLOG, '<gml:TimePeriod xsi:type="gml:TimePeriodType">\n') 
            WriteInLOG(zLOG, '<gml:beginPosition>%s</gml:beginPosition>\n' % (zDates[0]))
            WriteInLOG(zLOG, '<gml:endPosition>%s</gml:endPosition>\n'  % (zDates[1]))
            WriteInLOG(zLOG, '</gml:TimePeriod>\n')
            WriteInLOG(zLOG, '</gmd:extent>\n')
            WriteInLOG(zLOG, '</gmd:EX_TemporalExtent>\n')
            WriteInLOG(zLOG, '</gmd:temporalElement>\n')
    WriteInLOG(zLOG, '</gmd:EX_Extent>\n')
    WriteInLOG(zLOG, '</gmd:extent>\n')
    #End BLOC Extents
    
    WriteInLOG(zLOG, '</gmd:MD_DataIdentification>\n')
    WriteInLOG(zLOG, '</gmd:identificationInfo>\n')

def MakeDistributionInfoXML(self, zLOG):
    WriteInLOG(zLOG, '<gmd:distributionInfo>\n')
    WriteInLOG(zLOG, '<gmd:MD_Distribution>\n')
    zObj = getWidget(self, "tableformats")
    for i in range(zObj.rowCount()): MakeBlocFormat(self, zLOG, zObj, i)
   
    WriteInLOG(zLOG, '<gmd:transferOptions>\n')
    WriteInLOG(zLOG, '<gmd:MD_DigitalTransferOptions>\n')
    zObj = getWidget(self, "tablelocalisator")
    for i in range(zObj.rowCount()):
        WriteInLOG(zLOG, '<gmd:onLine>\n')
        WriteInLOG(zLOG, '<gmd:CI_OnlineResource>\n')
        WriteInLOG(zLOG, '<gmd:linkage>\n')
        WriteInLOG(zLOG, '<gmd:URL>%s</gmd:URL>\n' % (urllib.quote_plus(zObj.cellWidget(i, 0).text())))
        WriteInLOG(zLOG, '</gmd:linkage>\n')
        WriteInLOG(zLOG, '<gmd:name>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (urllib.quote_plus(zObj.cellWidget(i, 1).text())))
        WriteInLOG(zLOG, '</gmd:name>\n')
        WriteInLOG(zLOG, '</gmd:CI_OnlineResource>\n')
        WriteInLOG(zLOG, '</gmd:onLine>\n')
    WriteInLOG(zLOG, '</gmd:MD_DigitalTransferOptions>\n')
    WriteInLOG(zLOG, '</gmd:transferOptions>\n')
    
    WriteInLOG(zLOG, '</gmd:MD_Distribution>\n')
    WriteInLOG(zLOG, '</gmd:distributionInfo>\n')

def MakeDataQualityInfoXML(self, zLOG):
    zObj = getWidget(self, "typedata")
    zValue = self.TypeData[zObj.currentIndex()]
    
    WriteInLOG(zLOG, '<gmd:dataQualityInfo>\n')
    WriteInLOG(zLOG, '<gmd:DQ_DataQuality>\n')
    WriteInLOG(zLOG, '<gmd:scope>\n')
    WriteInLOG(zLOG, '<gmd:DQ_Scope>\n')
    WriteInLOG(zLOG, '<gmd:level>\n')
    WriteInLOG(zLOG, '<gmd:MD_ScopeCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#MD_ScopeCode" codeListValue="%s">%s</gmd:MD_ScopeCode>\n' % (zValue, zValue))
    WriteInLOG(zLOG, '</gmd:level>\n')
    WriteInLOG(zLOG, '</gmd:DQ_Scope>\n')
    WriteInLOG(zLOG, '</gmd:scope>\n')

    zObj = getWidget(self, "tablespecifications")

    if zObj.rowCount()> 0 : WriteInLOG(zLOG, '<gmd:report>\n')
    for i in range(zObj.rowCount()):
        zValueSPEC = zObj.cellWidget(i, 0).text() 
        if zValueSPEC != "" :
            WriteInLOG(zLOG, '<gmd:DQ_DomainConsistency xsi:type="gmd:DQ_DomainConsistency_Type">\n')
            WriteInLOG(zLOG, '<gmd:result>\n')
            WriteInLOG(zLOG, '<gmd:DQ_ConformanceResult xsi:type="gmd:DQ_ConformanceResult_Type">\n')
            WriteInLOG(zLOG, '<gmd:specification>\n')
            WriteInLOG(zLOG, '<gmd:CI_Citation>\n')
            WriteInLOG(zLOG, '<gmd:title>\n')
            WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValueSPEC))
            WriteInLOG(zLOG, '</gmd:title>\n')

            zValueDate = zObj.cellWidget(i, 1).text()
            if zValueDate.find("--") == -1 :
                zValueTypeDate = GetDateType(zObj.cellWidget(i, 2).currentIndex(), False) 
                MakeBlocDate(self, zLOG, zValueDate, zValueTypeDate)

            WriteInLOG(zLOG, '</gmd:CI_Citation>\n')
            WriteInLOG(zLOG, '</gmd:specification>\n')
            WriteInLOG(zLOG, '<gmd:explanation>\n')
            WriteInLOG(zLOG, '<gco:CharacterString>See the referenced specification</gco:CharacterString>\n')
            WriteInLOG(zLOG, '</gmd:explanation>\n')
            
            zIndesDegre = zObj.cellWidget(i, 3).currentIndex()
            if zIndesDegre == 0 : zValue = "true"
            elif zIndesDegre : zValue = "false"
            else : zValue = ""
            if zValue != "" :
                WriteInLOG(zLOG, '<gmd:pass>\n')
                WriteInLOG(zLOG, '<gco:Boolean>%s</gco:Boolean>\n' % (zValue))
                WriteInLOG(zLOG, '</gmd:pass>\n')
            else: WriteInLOG(zLOG, '<gmd:pass/>\n')   
            
            WriteInLOG(zLOG, '</gmd:DQ_ConformanceResult>\n')
            WriteInLOG(zLOG, '</gmd:result>\n')
            WriteInLOG(zLOG, '</gmd:DQ_DomainConsistency>\n')
    if zObj.rowCount()> 0 : WriteInLOG(zLOG, '</gmd:report>\n')

    zObj = getWidget(self, "genealogie")
    zValue = zObj.toPlainText()
    WriteInLOG(zLOG, '<gmd:lineage>\n')
    WriteInLOG(zLOG, '<gmd:LI_Lineage>\n')
    WriteInLOG(zLOG, '<gmd:statement>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zValue))
    WriteInLOG(zLOG, '</gmd:statement>\n')
    WriteInLOG(zLOG, '</gmd:LI_Lineage>\n')
    WriteInLOG(zLOG, '</gmd:lineage>\n')  

    WriteInLOG(zLOG, '</gmd:DQ_DataQuality>\n')
    WriteInLOG(zLOG, '</gmd:dataQualityInfo>\n')

def MakeSpatialRepresentation(self, zLOG):
    zObj = getWidget(self, "coherence")
    if zObj.toPlainText() != "" :
        import ast
        try : mydict = ast.literal_eval("%s" % (zObj.toPlainText()))
        except : mydict = None

        if mydict != None and type(mydict)==dict:

            zcondTopologyLevelCode = True if mydict.has_key('TopologyLevelCode') and mydict['TopologyLevelCode']!= 'unknow' else False
            zcondGeometricObjectTypeCode = True if mydict.has_key('GeometricObjectTypeCode') and mydict['GeometricObjectTypeCode']!= 'unknow' else False

            if zcondTopologyLevelCode or zcondGeometricObjectTypeCode :
                    WriteInLOG(zLOG, '<gmd:spatialRepresentationInfo>\n')
                    WriteInLOG(zLOG, '<gmd:MD_VectorSpatialRepresentation>\n')
                    if zcondTopologyLevelCode :
                        WriteInLOG(zLOG, '<gmd:topologyLevel>\n')
                        WriteInLOG(zLOG, '<gmd:MD_TopologyLevelCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#MD_TopologyLevelCode" codeListValue="%s">%s</gmd:MD_TopologyLevelCode>\n' % (mydict['TopologyLevelCode'], mydict['TopologyLevelCode']))
                        WriteInLOG(zLOG, '</gmd:topologyLevel>\n')
                    if zcondGeometricObjectTypeCode :    
                        WriteInLOG(zLOG, '<gmd:geometricObjects>\n')
                        WriteInLOG(zLOG, '<gmd:MD_GeometricObjects>\n')
                        WriteInLOG(zLOG, '<gmd:geometricObjectType>\n')
                        WriteInLOG(zLOG, '<gmd:MD_GeometricObjectTypeCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#MD_GeometricObjectTypeCode" codeListValue="%s">%s</gmd:MD_GeometricObjectTypeCode>\n' % (mydict['GeometricObjectTypeCode'],mydict['GeometricObjectTypeCode']))
                        WriteInLOG(zLOG, '</gmd:geometricObjectType>\n')
                        WriteInLOG(zLOG, '</gmd:MD_GeometricObjects>\n')
                        WriteInLOG(zLOG, '</gmd:geometricObjects>\n')
                    WriteInLOG(zLOG, '</gmd:MD_VectorSpatialRepresentation>\n')
                    WriteInLOG(zLOG, '</gmd:spatialRepresentationInfo>\n')

def MakeEndXML(self, zLOG):
    WriteInLOG(zLOG, '</gmd:MD_Metadata>')
    
#-----------------------------
# PRIMARY BLOC FOR XML EXPORT       
#----------------------------- 
def MakeBlocFormat(self, zLOG, zObj, i):
    if zObj.cellWidget(i, 0).styleSheet() == "background-color:#AEEE00;" :
        WriteInLOG(zLOG, '<gmd:distributionFormat>\n')
        WriteInLOG(zLOG, '<gmd:MD_Format>\n')
        WriteInLOG(zLOG, '<gmd:name>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 0).text()))
        WriteInLOG(zLOG, '</gmd:name>\n')
        WriteInLOG(zLOG, '<gmd:version>\n')
        WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 2).text())) 
        WriteInLOG(zLOG, '</gmd:version>\n')
        WriteInLOG(zLOG, '</gmd:MD_Format>\n')
        WriteInLOG(zLOG, '</gmd:distributionFormat>\n')
        """            
        WriteInLOG(zLOG, '<gmd:amendmentNumber></gmd:amendmentNumber>\n')
        WriteInLOG(zLOG, '<gmd:specification></gmd:specification>\n')
        WriteInLOG(zLOG, '<gmd:fileDecompressionTechnique></gmd:fileDecompressionTechnique>\n')
        WriteInLOG(zLOG, '<gmd:formatDistributor></gmd:formatDistributor>\n')
        """
    
def MakeBlocLangue(self, zLOG, zValue):
    WriteInLOG(zLOG, '<gmd:language>\n')
    WriteInLOG(zLOG, '<gmd:LanguageCode codeList="http://www.loc.gov/standards/iso639-2/" codeListValue="%s">%s</gmd:LanguageCode>\n' % (zValue, zValue))
    WriteInLOG(zLOG, '</gmd:language>\n')

def MakeBlocDate(self, zLOG, zValue, zType):
    WriteInLOG(zLOG, '<gmd:date>\n')
    WriteInLOG(zLOG, '<gmd:CI_Date>\n')
    WriteInLOG(zLOG, '<gmd:date>\n')
    WriteInLOG(zLOG, '<gco:Date>%s</gco:Date>\n' % (zValue))
    WriteInLOG(zLOG, '</gmd:date>\n')
    WriteInLOG(zLOG, '<gmd:dateType>\n')
    WriteInLOG(zLOG, '<gmd:CI_DateTypeCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#CI_DateTypeCode" codeListValue="%s">%s</gmd:CI_DateTypeCode>\n' % (zType, zType))
    WriteInLOG(zLOG, '</gmd:dateType>\n')
    WriteInLOG(zLOG, '</gmd:CI_Date>\n')
    WriteInLOG(zLOG, '</gmd:date>\n')

def MakeBlocRole(self, zLOG, zObj, zValue, i, isPointOfContact):
    WriteInLOG(zLOG, '<gmd:contact>\n') if isPointOfContact else WriteInLOG(zLOG, '<gmd:pointOfContact>\n')
    MakeResponsibleParty(self, zLOG, zObj, zValue, i, isPointOfContact)
    WriteInLOG(zLOG, '</gmd:contact>\n') if isPointOfContact else WriteInLOG(zLOG, '</gmd:pointOfContact>\n')

def MakeResponsibleParty(self, zLOG, zObj, zValue, i, isPointOfContact):
    WriteInLOG(zLOG, '<gmd:CI_ResponsibleParty>\n')
    WriteInLOG(zLOG, '<gmd:organisationName>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 1).text()))
    WriteInLOG(zLOG, '</gmd:organisationName>\n')
    WriteInLOG(zLOG, '<gmd:contactInfo>\n')
    WriteInLOG(zLOG, '<gmd:CI_Contact>\n')
    WriteInLOG(zLOG, '<gmd:address>\n')
    WriteInLOG(zLOG, '<gmd:CI_Address>\n')
    WriteInLOG(zLOG, '<gmd:deliveryPoint>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 2).text()))
    WriteInLOG(zLOG, '</gmd:deliveryPoint>\n')
    WriteInLOG(zLOG, '<gmd:city>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 5).text()))
    WriteInLOG(zLOG, '</gmd:city>\n')
    WriteInLOG(zLOG, '<gmd:postalCode>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 4).text()))
    WriteInLOG(zLOG, '</gmd:postalCode>\n')
    WriteInLOG(zLOG, '<gmd:country>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 3).currentText().rstrip().lstrip()))
    WriteInLOG(zLOG, '</gmd:country>\n')
    WriteInLOG(zLOG, '<gmd:electronicMailAddress>\n')
    WriteInLOG(zLOG, '<gco:CharacterString>%s</gco:CharacterString>\n' % (zObj.cellWidget(i, 6).text()))
    WriteInLOG(zLOG, '</gmd:electronicMailAddress>\n')
    WriteInLOG(zLOG, '</gmd:CI_Address>\n')
    WriteInLOG(zLOG, '</gmd:address>\n')
    WriteInLOG(zLOG, '</gmd:CI_Contact>\n')
    WriteInLOG(zLOG, '</gmd:contactInfo>\n')
    WriteInLOG(zLOG, '<gmd:role>\n')
    WriteInLOG(zLOG, '<gmd:CI_RoleCode codeList="http://standards.iso.org/ittf/PubliclyAvailableStandards/ISO_19139_Schemas/resources/Codelist/ML_gmxCodelists.xml#CI_RoleCode" codeListValue="%s">%s</gmd:CI_RoleCode>\n' % (zValue, zValue))
    WriteInLOG(zLOG, '</gmd:role>\n')
    WriteInLOG(zLOG, '</gmd:CI_ResponsibleParty>\n')
    
#-------------------------------
# FONCTIONs TO WRITE XML EXPORT       
#-------------------------------
def GetDateType(index, TheKey):
    if index > 2 : index = 0
    zDates = (("datecredata", "creation"), ("daterevdata","revision"), ("datepubdata","publication"))
    return zDates[index][0] if TheKey else zDates[index][1]
    
def MakeCAT(self, zText):
    zTemp = zText.split("(")
    zCat = zTemp[1].replace(")", "")
    return "%s" % (zCat)

def MakeLOG(self, zFile):
    zLOG = file(zFile, "w")
    return zLOG

def WriteInLOG(zLOG, zMsg):
    if zLOG != None : zLOG.write(zMsg.encode("utf-8"))

def CloseLOG(zLOG):     
    if zLOG != None : zLOG.close()

